-- --------------------------------------------------------------------------
-- Copyright  2008 PlayFirst, Inc. All Rights Reserved.
--
-- This material is the confidential trade secret and proprietary
-- information of PlayFirst, Inc. It may not be reproduced, used, disclosed,
-- sold or transferred without the prior written consent of PlayFirst, Inc. 
-- All rights reserved.
-- --------------------------------------------------------------------------
dofile( "scripts/help_style.lua" );

nameDialog = "help10";

HeaderTittle = "help_header_customers";

asset1 = "images/ui/help/bride";
asset2 = "images/ui/help/auntethel";
asset3 = "images/ui/help/uncleernie";
asset4 = "images/ui/help/celebrity";

Box1Tx = "help_customers_text_9_header";
Box2Tx = "help_customers_text_10_header";
Box3Tx = "help_customers_text_11_header";
Box4Tx = "help_customers_text_12_header";

definition1Tx = "help_customers_text_9";
definition2Tx = "help_customers_text_10";
definition3Tx = "help_customers_text_11";
definition4Tx = "help_customers_text_12";

paginateLabel = "help_paginate_10";

function BackCommand() 
	SwapToModal("scripts/help9.lua");
end

function NextCommand() 
	SwapToModal("scripts/help11.lua");
end

MakeDialog
{
	-- Name the modal dialog
	name = nameDialog,
	Bitmap
	{
		image="images/backgrounds/bgpopup01",
		x=kCenter,
		y=kCenter,
		
		Bitmap
		{
			image="images/ui/common/popup05",
			x=0,
			y=0,
		};
--Tittle
		Text
		{
			font = BigPopupFont,
			x=kCenter,
			y=kTitleY,
			w=kMax,h=45,
			flags = kHAlignCenter + kVAlignCenter,
			label = "help",
		};
--Header
		Text
		{
			font = PopupFont,
			x=kTextHeaderX,
			y=kTextHeaderY,
			w=kMax,h=45,
			flags = kHAlignLeft + kVAlignCenter,
			label = HeaderTittle,
		};
--Line 1
		Bitmap
		{
			image="images/ui/buttons/box06",
			x=kFirstRow,
			y=kFirstLine,
			
		};
		Bitmap
		{
			image=asset1,
			x=kFirstRow+35,
			y=kFirstLine,
			scale = 0.7,
		};
--Machine1 Name
		Bitmap
		{
			image="images/ui/buttons/box02",
			x=kFirstRow+kRowSpace,
			y=kFirstLine,
	
			Text
			{
				font = MachineFont,
				x=5,
				y=3,
				w=kMax,h=20,
				flags = kHAlignLeft + kVAlignCenter,
				label = Box1Tx,
			};
		};
		SetStyle(HelpTxDefStyle),
		Text
		{
			x=kFirstRow+kRowSpace,
			y=kFirstLine+kTextSpaceUnderBox,
			label = definition1Tx,
		};
--Line 2
		Bitmap
		{
			image="images/ui/buttons/box06",
			x=kFirstRow,
			y=kFirstLine+kLineSpace,
		};
		Bitmap
		{
			image=asset2,
			x=kFirstRow+30,
			y=kFirstLine+kLineSpace-5,
			scale = 0.8,
		};
--Machine2 Name
		Bitmap
		{
			image="images/ui/buttons/box02",
			x=kFirstRow+kRowSpace,
			y=kFirstLine+kLineSpace,
	
			Text
			{
				font = MachineFont,
				x=5,
				y=3,
				w=kMax,h=20,
				flags = kHAlignLeft + kVAlignCenter,
				label = Box2Tx,
			};
		};
		Text
		{
			x=kFirstRow+kRowSpace,
			y=kFirstLine+kTextSpaceUnderBox+kLineSpace,
			label = definition2Tx,
		};
--Line 3
		Bitmap
		{
			image="images/ui/buttons/box06",
			x=kFirstRow,
			y=kFirstLine+2*kLineSpace,
		};
		Bitmap
		{
			image=asset3,
			x=kFirstRow+30,
			y=kFirstLine+2*kLineSpace-5,
			scale = 0.78,
		};
--Machine3 Name
		Bitmap
		{
			image="images/ui/buttons/box02",
			x=kFirstRow+kRowSpace,
			y=kFirstLine+2*kLineSpace,
	
			Text
			{
				font = MachineFont,
				x=5,
				y=3,
				w=kMax,h=20,
				flags = kHAlignLeft + kVAlignCenter,
				label = Box3Tx,
			};
		};
		Text
		{
			x=kFirstRow+kRowSpace,
			y=kFirstLine+kTextSpaceUnderBox+2*kLineSpace,
			label = definition3Tx,
		};
--Line 4
		Bitmap
		{
			image="images/ui/buttons/box06",
			x=kFirstRow,
			y=kFirstLine+3*kLineSpace,
		};
		Bitmap
		{
			image=asset4,
			x=kFirstRow+35,
			y=kFirstLine+3*kLineSpace,
			scale = 0.7,
		};
--Machine4 Name
		Bitmap
		{
			image="images/ui/buttons/box02",
			x=kFirstRow+kRowSpace,
			y=kFirstLine+3*kLineSpace,
	
			Text
			{
				font = MachineFont,
				x=5,
				y=3,
				w=kMax,h=20,
				flags = kHAlignLeft + kVAlignCenter,
				label = Box4Tx,
			};
		};
		Text
		{
			x=kFirstRow+kRowSpace,
			y=kFirstLine+kTextSpaceUnderBox+3*kLineSpace,
			label = definition4Tx,
		};
		SetStyle(FitnessButtonStyleTittleSmallBlue),
--//Back
		SBButton
		{
			x=kButtonX,
			y=kButtonY,
			
			icon="assets/images/ui/buttons/icon/iconback",
			command=
				function()
					-- Our game provides this call--it's not a Playground
					-- call.
                    BackCommand();
				end
		},
		Text
		{
			font = SmallFont,
			x=kButtonX,
			y=kButtonY+kTextY,
			flags = kHAlignCenter + kVAlignCenter,
			label = "common.back.label",
		};
--Next
		SBButton
		{
			x=kButtonX+kButtonSpaceX,
			y=kButtonY,
			
			icon="assets/images/ui/buttons/icon/iconplay",
			command=
				function()
					-- Our game provides this call--it's not a Playground
					-- call.
                    NextCommand();
				end
		},
		Text
		{
			font = SmallFont,
			x=kButtonX+kButtonSpaceX,
			y=kButtonY+kTextY,
			flags = kHAlignCenter + kVAlignCenter,
			label = "next",
		};
--Paginate
		Text
		{
			font = SmallFontBlack,
			flags = kHAlignCenter + kVAlignCenter,
			x=kPaginateX,
			y=kPaginateY,
			w=kMax,h=30,
			
			label = paginateLabel,
		};
	}
}

